<?php $page="all";
$UserType = Session::get('UserType');
$UserId = Session::get('UserId');
?>
<?php echo e(authUser()); ?>

<!DOCTYPE html>

<html lang="en" class="default-style">

<head>
    <title><?php echo e(projectTitle()); ?></title>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->make('headerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
    <!-- [ Preloader ] Start -->
    <div class="page-loader">
        <div class="bg-primary"></div>
    </div>
    <!-- [ Preloader ] End -->

    <!-- [ Layout wrapper ] Start -->
    <div class="layout-wrapper layout-1 layout-without-sidenav">
        <div class="layout-inner">
            <!-- [ Layout sidenav ] Start -->
            <?php $__env->startSection('topheader'); ?>

            <!-- [ Layout navbar ( Header ) ] End -->
            <?php echo $__env->yieldSection(); ?>
            <?php $__env->startSection('header'); ?>
            <div class="sidenav bg-dark align-items-lg-center">
                <div id="layout-sidenav"
                    class=" container layout-sidenav-horizontal sidenav-horizontal flex-grow-0 bg-dark" style="max-width: 1200px;">

                    <!-- Links -->
                    <ul class="sidenav-inner">
                        <!-- Dashboards -->

                        <!-- Layouts -->
                        <li class="sidenav-divider mb-1"></li>
                        <li class="sidenav-header small font-weight-semibold">UI Components</li>

                        <?php if($UserType == 'Optometrist'): ?>
                            <?php echo $__env->make('incoptomenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>

                        <?php if($UserId == '38' || $UserId == '39' || $UserId == '40'): ?>
                            <?php echo $__env->make('incotherconsultmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>

                        <?php if($UserId == '38' || $UserId == '39' || $UserId == '40'): ?>
                        <?php else: ?>
                        <?php if($UserType == 'Consultant' || $UserType == 'Admin' || $UserType == 'Superadmin'): ?>

                            <?php echo $__env->make('incadminmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                           
                        <?php endif; ?>
                        <?php endif; ?>

                        

                        <?php if($UserType == 'Reception'): ?>
                            <?php echo $__env->make('increceptionmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>

                        <?php if($UserType == 'Optical'): ?>
                            <?php echo $__env->make('incopticalmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>

                    </ul>
                </div>
            </div>

            
            <?php echo $__env->yieldSection(); ?>
            <!-- [ Layout sidenav ] End -->
            <!-- [ Layout container ] Start -->
            <div class="layout-container">
                <!-- [ Layout navbar ( Header ) ] Start -->

                <!-- [ Layout content ] Start -->
                <div class="layout-content">

                    <!-- [ content ] Start -->

                    <?php $__env->startSection('content'); ?>
                    <?php echo $__env->yieldSection(); ?>

                    <!-- [ content ] End -->
                    <?php $__env->startSection('footer'); ?>
                    <!-- [ Layout footer ] Start -->
                    <nav class="layout-footer footer footer-light">
                        <div
                            class="container-fluid d-flex flex-wrap justify-content-between text-center container-p-x pb-3">
                            <div class="pt-3">
                                <span class="float-md-right d-none d-lg-block"  style="color: black;">&copy; <?php echo e(Session::get('User_Name')); ?> <i
                                        class="fas fa-heart text-danger mr-2"></i></span>
                            </div>

                        </div>
                    </nav>
                    <!-- [ Layout footer ] End -->
                    <?php echo $__env->yieldSection(); ?>
                </div>
                <!-- [ Layout content ] Start -->
            </div>
            <!-- [ Layout container ] End -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-sidenav-toggle"></div>
    </div>

    <?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->startSection('scriptcontent'); ?>

    <?php echo $__env->yieldSection(); ?>
    <script>
    function openNewWindow(val, height, width, left, top, right, bottom) {
        setTimeout(function() {
            window.open(
                '/<?php echo e(projectUrl()); ?>' + val, val,
                'height=' + height + ',width=' + width + ',left=' + left + ',top=' + top + ',right=' +
                right + ',bottom=' + bottom +
                ',resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }
    </script>
</body>

</html><?php /**PATH I:\deshmukh_hosp\resources\views/layout.blade.php ENDPATH**/ ?>