<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php
$UserId = Session::get('UserId');
?>

<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Vendor Bill Managements
        <span style="float: right;">
            <a href="/<?php echo e(projectUrl()); ?>addVendorReceipt" class="btn btn-secondary btn-round"><i
                    class="ion ion-md-add mr-2"></i> New Bill</a></span>
    </h4>
    <div class="card mb-4">
        <div class="card-body">
            <div id="alert_message"></div>

            <div class="row align-items-center m-l-0">

            <div class="col-sm-4">
                        <div class="form-group">
                            <label class="floating-label" for="Name">Vendor Name <span
                                    class="text-danger">*</span></label>
                                <select class="select2-demo form-control" id="VedId" name="VedId" required>
                                <option value="all" selected>All</option>

                                <?php $__currentLoopData = $vedlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($result->id); ?>"><?php echo e($result->VedName); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                        </div>
                    </div>

            <div class="col-sm-2">
                <div class="form-group">
                    <label class="floating-label" for="gender">Payment Mode </label>
                    <select class="form-control" id="PayMode" name="PayMode">
                        <option value="">All</option>
                        <option value="Cash">Cash</option>
                        <option value="Cheque">Cheque</option>
                        <option value="Mobile Payment">Mobile Payment</option> 
                    </select>
                </div>
            </div>
            <div class="form-group col-md-2">
                <label class="form-label">From Date </label>
                <input type="date" id="FromDate" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" autocomplete="off"
                    required>
            </div>
            <div class="form-group col-md-2">
                <label class="form-label">To Date</label>
                <input type="date" id="ToDate" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" autocomplete="off"
                    required>
            </div>
            <input type="hidden" name="Search" value="Search">
            <div class="form-group col-md-1" style="padding-top:20px;">
                <button type="button" class="btn btn-primary btn-finish" id="filter">Search</button>
                <!-- <button type="button" id="refresh" class="btn btn-secondary btn-finish">Refresh</button> -->
            </div>
            </div>

            <div class="table-responsive" id="custresult">


            </div>
        </div>
    </div>




</div>

<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('excelscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript">
function printFile(file) {
    setTimeout(function() {
        window.open('/<?php echo e(projectUrl()); ?>printVendorReceipt/' + file, 'popUpWindow33',
            'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function showFile(file) {
    setTimeout(function() {
        window.open('/<?php echo e(projectUrl()); ?>uploads/' + file, 'popUpWindow3',
            'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

$(document).ready(function() {
    queueList();
    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Record!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "<?php echo e(url('deleteVendorReceipt')); ?>",
                    method: "POST",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id
                    },
                    beforeSend: function() {
                        $('.confirm').attr('disabled', 'disabled');
                        $('.confirm').text('Please Wait...');
                    },

                    success: function(data) {

                        swal("Deleted!", "Record has been deleted.", "success");
                        //window.location.href = "/queuemanagement";
                        queueList();



                    }
                });

            } else {
                swal("Cancelled", "Record is safe :)", "error");
            }
        });


    });
});

$('#filter').click(function(){
  var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
  var VedId = $('#VedId').val();
  var PayMode = $('#PayMode').val();
   queueList(FromDate,ToDate,VedId,PayMode);
 });

 $('#refresh').click(function(){
  $('#FromDate').val('');
  $('#ToDate').val('');
  $('#VedId').val('');
  $('#PayMode').val('');
  queueList();
 });

function queueList(FromDate = '', ToDate = '',VedId= '',PayMode='') {
    //alert(FromDate);alert(MrdNo);
    $.ajax({
        url: "<?php echo e(url('viewVendorReceipt')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            FromDate: FromDate,
            ToDate: ToDate,
            VedId:VedId,
            PayMode:PayMode
        },
        success: function(data) {
            console.log(data);
            $('#custresult').html(data);
        }
    });
}
</script>
</script><?php /**PATH C:\vyawaharehosp_new_2\resources\views//vendors/view-vendor-receipt.blade.php ENDPATH**/ ?>