<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php
$UserId = Session::get('UserId');
?>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">OPD Expenses
    </h4>
    <div class="card mb-4">
        <div class="card-body">

            <div class="row align-items-center m-l-0">



                <div class="col-sm-2 text-left">
                    <button class="btn btn-success btn-sm mb-3 btn-round" data-toggle="modal"
                        data-target="#modal-report" id="add_button"><i class="feather icon-plus"></i> Add
                        Expenses</button>
                </div>
                <div class="form-group col-md-2">
                            <label class="form-label">From Date </label>
                            <input type="date" id="FromDate" class="form-control" value="" autocomplete="off" required>
                        </div>
                        <div class="form-group col-md-2">
                            <label class="form-label">To Date</label>
                            <input type="date" id="ToDate" class="form-control" value="" autocomplete="off" required>
                        </div>
                        <input type="hidden" name="Search" value="Search">
                        <div class="form-group col-md-3" style="padding-top:20px;">
                            <button type="button" class="btn btn-primary btn-finish"
                            id="filter">Search</button>
                            <button type="button" id="refresh" class="btn btn-secondary btn-finish">Refresh</button>
                        </div>

                        <div class="col-sm-3 text-right">
                            <a href="javascript:void(0)" class="badge badge-pill badge-danger" id="today">Today's Total Expenses :
                                <?php echo e($today); ?></a>
                            <a href="javascript:void(0)" class="badge badge-pill badge-success"
                                id="total">Total Expenses : <?php echo e($total); ?></a>
                            
                        </div>
                


            </div>
            <hr>
            <div class="table-responsive" id="custresult">


            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" style="max-width: 70rem; ">
        <div class="modal-content">


            <div class="modal-header">
                <h5 class="modal-title">Add OPD Expenses</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="validation-form" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="action" id="action" value="Save">
                    <input type="hidden" name="id" id="id" />
                    <input type="hidden" name="ConsultantId" id="ConsultantId" />
                    <input type="hidden" name="Consultant" id="Consultant" />
                    <div class="row">
                        
                    <div class="col-sm-5">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Expenses </label>
                                <input type="text" class="form-control" id="Narration" Name="Narration" placeholder=""
                                    >
                            </div>
                        </div>

                    <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Amount <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="Amount" Name="Amount" placeholder="" required>
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Date <span
                                        class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="CreatedDate" Name="CreatedDate" placeholder="" required>
                            </div>
                        </div>
                        <input type="hidden" id="PayMode" name="PayMode" value="Cash">
                        <!-- <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Payment Mode <span
                                        class="text-danger">*</span></label>
                                <select class="form-control" id="PayMode" name="PayMode" required>
                                    <option value=""></option>
                                    <option value="Cash">Cash</option>
                                    <option value="Card">Card</option>
                                    <option value="Mobile Payment">Mobile Payment</option>
                                </select>
                            </div>
                        </div> -->
                        <!-- <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Cheque No</label>
                                <input type="text" class="form-control" id="ChequeNo" Name="ChequeNo" placeholder="">
                            </div>
                        </div> -->
                        
                       
                        <div class="col-sm-3" style="padding-top:20px;">
                            <button class="btn btn-primary" type="submit" name="submit" id="submit">Submit</button>
                            <button class="btn btn-danger" type="reset">Clear</button>
                        </div><br>
                        <div class="col-sm-12" id="custresult2" style="padding-top: 25px;">

                        </div>

                    <input type="hidden" id="CurrDate" value="<?php echo e(date('Y-m-d')); ?>">


                        
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('excelscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript">
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Expenses Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Expenses Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}

function printCard(id){
    setTimeout(function () {
    window.open(
        '/<?php echo e(projectUrl()); ?>opdExpensePrint/'+id, 'name', 'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=900, height=1000'
    );
}, 1);
}

$('#filter').click(function(){
  var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
  if(FromDate != '' &&  ToDate != '')
  {
   queueList(FromDate, ToDate);
  }
  else
  {
   alert('Both Date is required');
  }
 });

 $('#refresh').click(function(){
  $('#FromDate').val('');
  $('#ToDate').val('');
  queueList();
 });


function queueList(FromDate = '', ToDate = '') {
    $.ajax({
        url: "<?php echo e(url('viewOpdExpense')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            FromDate: FromDate,
            ToDate: ToDate
        },
        success: function(data) {
            //console.log(data);
            $('#custresult').html(data);
        }
    });
}

function getProcRec() {
    $.ajax({
        method: "POST",
        url: "<?php echo e(url('getExpenseProcRec')); ?>",
        data: {
            _token: '<?php echo e(csrf_token()); ?>'
        },
        success: function(data) {
            //console.log(data);
            $('#custresult2').html(data);
        }
    });
}

function getProcRec2(id) {
    $.ajax({
        method: "POST",
        url: "<?php echo e(url('getExpenseProcRec2')); ?>",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            id:id
        },
        success: function(data) {
            //console.log(data);
            $('#custresult2').html(data);
        }
    });
}

$(document).ready(function() {
    $('#modal-report').modal('show');
    queueList();
    var CurrDate = $('#CurrDate').val();
    $('#CreatedDate').val(CurrDate)

    $(document).on("change", "#PatientId", function(event) {
        var val = this.value;
        $.ajax({
            url: "<?php echo e(url('getPatientDetails')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                id: val
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
               
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#ConsultantId').val(data.Consultant);
                $('#Consultant').val(data.ConsultantName);
        
             
            }
        });

    });

    $('#add_button').click(function() {
        //getProcRec();
        var CurrDate = $('#CurrDate').val();
        $('.modal-title').html("Add <span class='font-weight-light'>Expenses</span>");
        $('#action').val("Save");
        $('#id').val('');
        $('#PatientId').val('');
        $('#MrdNo').val('');
        $('#PatientName').val('');
        $('#AgeGender').val('');
        $('#Amount').val('');
        $('#ChequeNo').val('');
        $('#Narration').val('');
        $('#CreatedDate').val(CurrDate)
        $('#PayMode').val('').attr("selected", true);
        $('#submit').text('Submit');

    })

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "<?php echo e(url('saveOpdExpense')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {

                    //console.log(data);exit();
                    var res = JSON.parse(data);
                    var status = res.status;
                    var today = res.today;
                    var total = res.total;
                    var id = res.id;
                    if (status == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        queueList();
                        $('#today').html('Todays Total Expenses : '+today);
                        $('#total').html(' Total Expenses : '+total);
                        //window.location.href="ipd-receipt.php";
                        //window.open('ipd-receipt-print.php?id='+id,'_blank');
                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                }
            });
        }
    });

    $(document).on("click", ".update", function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr("data-id");
        $.ajax({
            url: "<?php echo e(url('fetchOpdExpenseRecord')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                id: id
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
                $('#PatientId').val(data.PatientId).attr("selected",true);
                $('#IpdNo').val(data.IpdNo);
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#Amount').val(data.Amount);
                $('#PayMode').val(data.PayMode).attr("selected", true);
                $('#ChequeNo').val(data.ChequeNo);
                $('#Narration').val(data.Narration);
                $('#AdmissionDate').val(data.AdmissionDate);
                $('#AdmissionTime').val(data.AdmissionTime);
                $('#DepositDate').val(data.DepositDate);
                $('#DepositTime').val(data.DepositTime);
                $('#action').val('Edit');

                $('#id').val(id);
                getProcRec2(id);
                $('#submit').text("Update");
                $('#modal-report').modal('show');
                $('.modal-title').html(
                    "Update <span class='font-weight-light'>Expenses</span>");

            }
        });
    });



    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Charges!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "<?php echo e(url('deleteOpdExpense')); ?>",
                    method: "POST",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id
                    },

                    success: function(data) {
                        var res = JSON.parse(data);
                        var status = res.status;
                        var today = res.today;
                        var total = res.total;
                        queueList();
                        $('#today').html('Todays Total Expenses : '+today);
                        $('#total').html(' Total Expenses : '+total);
                        swal("Deleted!", "Expenses has been deleted.", "success");

                    }
                });

            } else {
                swal("Cancelled", "Expenses is safe :)", "error");
            }
        });
    });

});
</script>
</script>
<?php /**PATH C:\vyawaharehosp_new_2\resources\views//opd/view-opd-expense.blade.php ENDPATH**/ ?>